#version 3.7;

#declare IsRadActive = true;

global_settings{
	assumed_gamma 1.0
	#if( IsRadActive )
		#default { finish{ ambient 0 } }
		radiosity{
			pretrace_start 64 / image_width
			pretrace_end 4 / image_width
			error_bound 0.2
			minimum_reuse 0.015
			nearest_count 9
			count 800
			recursion_limit 1
			always_sample off
			low_error_factor 0.7
			gray_threshold 0
			brightness 1
			normal on
			media on
			adc_bailout 0.01/2		
		}
	#end
}

#include "colors.inc"
#include "woods.inc"
#include "skies.inc"
#include "stones.inc"
#include "includes/houseElements.inc"
#include "includes/mountains.inc"

camera {
	location  <40.0, 20.0, 30.0>
	look_at   <7.0, 20.0, -10.0>
	right x * image_width / image_height
}

light_source{ <1, 2, 1 > * 1000000 color srgb < 1, 1, 0.98 > * 0.85 }

//The ground
prism {linear_sweep linear_spline -1,0,6,
	<70,-60> <-19,-80> <-200,-80> <-200,60> <100,60> <70,-60>
	pigment{ bozo color_map{
		[0.0 White*1.4]
		[0.3 Gray80 ]
		[0.4 Gray70   ]
		[0.5 White*1.4]
		[1.0 White*1.4]
		}
	}
}

object{ CompleteHouse }      

sky_sphere{ S_Cloud1 }

object{ BackgroundMountains scale <300,500,300> translate <-52,-36,-400> }

//Snow around house
height_field {
	png              
	"includes/HFneige.png"    
	smooth
	texture {pigment {White*1.4}}
	scale <100,4,60> translate <-60,-0.1,-40>
}


object{	Estrade 
		rotate 20*y translate <-19,0,-80> 
		texture{ SnowAndGranite scale 4 } 
} 