//A macro to set an input value bounded to an affine function property
//Only on return value per macro

#macro SetWithAffineFunction( X1, X2, Y1, Y2, CurrentX )
	#if( X1 = X2 )
		#error "Can't render, because X1 and X2 have equal values"
	#end
	#local DirCoef = (Y2 - Y1) / ( X2 - X1 );
	#local OrigineOffset = Y1 - (DirCoef * X1);

	#local RetValue = DirCoef * CurrentX + OrigineOffset;
	RetValue
#end


//don't make a return function of this macro (in case of returning a value that is not bounded, it returns a not desired value)
#macro SetIfInsideInterval( X1, X2, Y1, Y2, CurrentX, ValueToSet )
	#if( CurrentX >= X1 & CurrentX <= X2 )
		#declare ValueToSet = SetWithAffineFunction( X1, X2, Y1, Y2, CurrentX );
	#end
#end