/*
       Title: Bricks.Inc
      Author: Jeff Lee <shipbrk@gate.net>
 Description: Creates a decent brick pattern, with random variation in brick colour.
     Version: 1.0
        Date: 19 February 1998
    Platform: POV-Ray 3.0
*/

#ifdef (Quick)
  #ifndef (newBrickMidtone)
    #declare newBrickMidtone=colour srgb <0.60,0.10,0.10>;
  #end
  #declare T_newBrick = texture { pigment { newBrickMidtone }}
#else
  #ifdef (newBrickLoadDefaults)
    #if (newBrickLoadDefaults=1)
      #declare newBrickWidth=8;
      #declare newBrickHeight=3;
      #declare newBrickDepth=4.5;
      #declare newBrickMortarWidth=0.35;
      #declare newBrickLowlightPos=0.20;
      #declare newBrickHighlightPos=0.80;
      #declare newBrickLowlight=colour srgb <0.40,0.05,0.00>;
      #declare newBrickHighlight=colour srgb <0.75,0.25,0.10>;
      #declare newBrickMidtone=colour srgb <0.60,0.10,0.10>;
      #declare newBrickClearMortar=0;
      #declare newBrickMortar=colour srgb <0.90,0.89,0.85>;
      #declare newBrickBozoScale=100;
      #declare newBrickTurbulence=0.05;
      #declare newBrickNormal=normal { granite 0.1 }
      #declare newBrickFinish=finish {}
      #declare newBrickLoadDefaults=0;
    #end
  #end
  #ifndef (newBrickWidth)
    #declare newBrickWidth=8;
  #end
  #ifndef (newBrickHeight)
    #declare newBrickHeight=3;
  #end
  #ifndef (newBrickDepth)
    #declare newBrickDepth=4.5;
  #end
  #ifndef (newBrickMortarWidth)
    #declare newBrickMortarWidth=0.35;
  #end
  #ifndef (newBrickHighlight)
    #declare newBrickHighlight=colour srgb <0.75,0.25,0.10>;
  #end
  #ifndef (newBrickLowlight)
    #declare newBrickLowlight=colour srgb <0.40,0.05,0.00>;
  #end
  #ifndef (newBrickMidtone)
    #declare newBrickMidtone=colour srgb <0.60,0.10,0.10>;
  #end
  #ifndef (newBrickClearMortar)
    #declare newBrickClearMortar=0;
  #end
  #ifndef (newBrickMortar)
    #if (newBrickClearMortar=1)
      #declare newBrickMortar=colour srgbt <1,1,1,1>;
    #else
      #declare newBrickMortar=colour srgb <0.90,0.89,0.85>;
    #end
  #end
  #ifndef (newBrickBozoScale)
    #declare newBrickBozoScale=100;
  #end
  #ifndef (newBrickHighlightPos)
    #declare newBrickHighlightPos=0.80;
  #end
  #ifndef (newBrickLowlightPos)
    #declare newBrickLowlightPos=0.20;
  #end
  #ifndef (newBrickTurbulence)
    #declare newBrickTurbulence=0.05;
  #end
  #ifndef (newBrickNormal)
    #declare newBrickNormal=normal { granite 0.1 }
  #end
  #ifndef (newBrickFinish)
    #declare newBrickFinish=finish {}
  #end
  
  #declare P_newBrickA = pigment { 
    bozo
    pigment_map {
      [0.00                 newBrickMidtone]
      [newBrickLowlightPos  newBrickLowlight]
      [newBrickHighlightPos newBrickHighlight]
      [1.00                 newBrickMidtone]
    }
    scale newBrickBozoScale
  }
  
  #declare P_newBrickB = pigment {
    P_newBrickA
    warp { repeat x*newBrickWidth offset <0,15*newBrickHeight,0> }
  }
  
  #declare P_newBrickC = pigment {
    P_newBrickB
    warp { repeat z*newBrickDepth offset <0,20*newBrickHeight,0> }
  }
  
  #declare P_newBrickD = pigment {
    P_newBrickC
    warp { repeat y*newBrickHeight offset <newBrickWidth*7.5,0,newBrickDepth*6.5> }
    translate z*(newBrickDepth/2)
  }
  
  #declare P_newBrickMortar = pigment { newBrickMortar }
  
  #declare P_newBrick = pigment {
    brick pigment { P_newBrickMortar }, pigment { P_newBrickD }
    brick_size <newBrickWidth,newBrickHeight,newBrickDepth>
    mortar newBrickMortarWidth
  }
  
  #declare T_newBrick = texture {
    pigment { P_newBrick turbulence newBrickTurbulence }
    normal { newBrickNormal }
    finish { newBrickFinish }
  }
#end
