#declare NeonHalo =
cylinder{ < 0, 0, 0 >, < 0, 2, 0 >,1 hollow pigment{ color srgbt 1 } 
	interior{
		media{
			intervals 3
			emission srgb 2.25
			density{
				cylindrical color_map{
					[0 color srgb 0.8][1.0 color srgb 1]
				}
			}
		} 
	}  
    scale <0.18, 1, 0.18>    
}


//default boundaries < -0.1, 0.14, -0.1 >,< 0.1, 1.86, 0.1 >                       
#macro AddNeonTube(NeonPosition, GuardRotate, PointAt)
	union{
		//The neon tube
		cylinder{<0,0.14,0>, <0, 1.86, 0>, 0.1 hollow pigment{ color srgb 1 transmit 1 }  
			no_shadow
		}    
		//The neonHalo
		object{NeonHalo}                  
		light_source{<0, 0.5, 0> 
			color srgb 1
			spotlight
			radius 25
			falloff 26
			point_at < PointAt.x - NeonPosition.x, PointAt.y - NeonPosition.y, PointAt.z - NeonPosition.z > 
		}
           
           //prism front
           #local LR=0.2;               
                         //A           B              C               D           E           F            G          H          A closing
           prism{0, 2, 9 <LR, 0.15>, <-0.15, 0.15>, <-0.15, -0.15>, <LR, -0.15>, <LR, -0.2>,<-0.2, -0.2>,<-0.2, 0.2>, <LR,0.2>, <LR,0.15>
               
                 rotate GuardRotate * y
                 texture{ pigment{ color srgb 0.85 } finish{ metallic } }
           }

        translate NeonPosition
     }
#end