#declare ArialFontPath = "fonts/arial.ttf"

#declare DoorA_Yellow = color srgb < 236 / 255, 236 / 255, 35 / 255 >;
#declare DoorA_Black = color srgb 0.1;
#declare DoorA_MainColor = color srgb 0.75;
#declare DoorA_BiasPig = pigment{ gradient y color_map{
								[ 0.0 DoorA_Black ]
								[ 0.5 DoorA_Black ]
								[ 0.5 DoorA_Yellow ]
								[ 1.0 DoorA_Yellow ]
													}
								scale 0.25
								rotate 45 * z
						} 

#declare DoorA_BiasFinish = finish{ specular 0.01 roughness 0.01 }
#declare DoorA_MainFinish = finish{ metallic specular 0.1 roughness 0.01 }
#declare DoorA_BiasTexture = texture{ pigment{ DoorA_BiasPig } finish{ DoorA_BiasFinish } }
#declare DoorA_MainTexture = texture{ pigment{ DoorA_MainColor } finish{ DoorA_MainFinish } }

#declare DoorA_FloorInterstice = 0.025;
#declare DoorA_HangarZ_Pos = 12;
#declare DoorB_HangarX_Pos = 12;
#declare DoorA_Width = 6;
#declare DoorA_Depth = 0.45;
#declare DoorA_Height = 4 - DoorA_FloorInterstice;
#declare DoorA_BiasWidth = 0.15;
#declare DoorA_PrismReliefWidth = 0.45;
#declare DoorA_ReliefCorner = 0.035;
#declare DoorA_ReliefCount = 3;
#declare DoorA_ReliefDiffDecalCount = 0.001;

//The yellow and black door join
#declare DoorA_GradientBias = 
prism{ linear_sweep linear_spline DoorA_FloorInterstice, DoorA_Height, 4, 
		< DoorA_Width / 2 - DoorA_BiasWidth, 0 >,
		< DoorA_Width / 2, DoorA_Depth / 2 >,
		< DoorA_Width / 2 - DoorA_BiasWidth, DoorA_Depth >,
		< DoorA_Width / 2 - DoorA_BiasWidth, 0 >
		texture{ DoorA_BiasTexture }
}

#declare DoorA_Relief =
prism{ linear_sweep linear_spline DoorA_FloorInterstice, DoorA_Height, 5,
	< -DoorA_PrismReliefWidth / 2, DoorA_Depth + DoorA_ReliefDiffDecalCount >, 
	< DoorA_PrismReliefWidth / 2, DoorA_Depth + DoorA_ReliefDiffDecalCount >, 
	< DoorA_PrismReliefWidth / 2 - DoorA_ReliefCorner * 2 + DoorA_ReliefDiffDecalCount, DoorA_Depth - DoorA_ReliefCorner >,
	< -DoorA_PrismReliefWidth / 2 + DoorA_ReliefCorner * 2 - DoorA_ReliefDiffDecalCount, DoorA_Depth - DoorA_ReliefCorner >,
	< -DoorA_PrismReliefWidth / 2, DoorA_Depth + DoorA_ReliefDiffDecalCount >
	texture{ DoorA_MainTexture }  
}

#declare DoorA_LeftPart =
union{
	object{ DoorA_GradientBias }
	difference{
		box{ < 0, DoorA_FloorInterstice, 0 >, < DoorA_Width / 2 - DoorA_BiasWidth, DoorA_Height, DoorA_Depth > 
			texture{ DoorA_MainTexture }
		}
	#for( It, 0, DoorA_ReliefCount - 1 )
		object{ DoorA_Relief translate < ( (DoorA_Width / 2 - DoorA_BiasWidth) * It / DoorA_ReliefCount ) + DoorA_PrismReliefWidth, 0, 0 > }
		object{ DoorA_Relief translate -DoorA_Depth * z rotate 180 * y 
			translate < ( (DoorA_Width / 2 - DoorA_BiasWidth) * It / DoorA_ReliefCount ) + DoorA_PrismReliefWidth, 0, 0 > }
	#end
	}
}

//----Exit text things
#declare TextDepth = 0.08;

#declare ExitText =
text{
	ttf ArialFontPath "Exit" TextDepth, < 0, 0 >
	scale < 0.5, 0.5, 1 >
	rotate 90 * y
	texture{ pigment{ color srgb < 151 / 255, 33 / 255, 21 / 255 > } finish{ DoorA_BiasFinish } }
}

#declare ExitTextCenter = ( max_extent( ExitText ) + min_extent( ExitText ) ) / 2;

#declare StaffText =
text{
	ttf ArialFontPath "Staff wing" TextDepth, < 0, 0 >
	scale < 0.5, 0.5, 1 >
	texture{ pigment{ color srgb < 151 / 255, 33 / 255, 21 / 255 > } finish{ DoorA_BiasFinish } }
}

#declare StaffTextCenter = ( max_extent( StaffText ) + min_extent( StaffText ) ) / 2;

//------Access console things
#declare ConsoleColor = color srgb 1;
#declare ConsoleKeyColor = color srgb < 133 / 255, 219 / 255, 222 / 255>;
#declare ConsoleFinish = finish{ specular 0.15 roughness 0.01 }
#declare ConsoleWidth = 0.3;
#declare ConsoleHeight = 0.4;
#declare KeyWidth = ConsoleWidth / 5;
#declare KeyHeight = ConsoleHeight / 7;
#declare DigitNumberScale = KeyHeight / 1; 
#declare DigitsScreenWidth = ConsoleWidth * 7 / 9;

#declare ConsoleKey = box{ < -0.005, -KeyHeight / 2, -KeyWidth / 2 >, < -0.012, KeyHeight / 2, KeyWidth / 2 > texture{ pigment{ ConsoleKeyColor } finish{ ConsoleFinish } } }

#macro PlaceConsoleKey(DigitNumber, Position)
	object{ ConsoleKey translate Position + 0.05 * y }
	#local DigitNumberText =
	text{ ttf ArialFontPath str(DigitNumber, 0, 0), 0.001, < 0, 0 >
		texture{ pigment{ color srgb 0.1 } finish{ specular 0.01 roughness 0.01 } }
		scale < DigitNumberScale, DigitNumberScale, 1 >
		rotate -270 * y
	}
	#local DigitNumberTextCenter = ( max_extent( DigitNumberText ) + min_extent( DigitNumberText ) ) / 2;
	object{ DigitNumberText 
		translate -DigitNumberTextCenter + Position + < -0.012 - 0.001, 0.05, 0 >
	}
#end

#declare DoorConsole = 
union{
	box{ < 0, 0, -ConsoleWidth / 2 >, < -0.01, ConsoleHeight, ConsoleWidth / 2 > 
		texture{ pigment{ ConsoleColor } finish{ ConsoleFinish } }
	}
	PlaceConsoleKey(1, < 0, KeyHeight, ConsoleWidth / 4 > )
	PlaceConsoleKey(2, < 0, KeyHeight, 0 > )
	PlaceConsoleKey(3, < 0, KeyHeight, -ConsoleWidth / 4 > )
	PlaceConsoleKey(4, < 0, KeyHeight * 2.2, ConsoleWidth / 4 > )
	PlaceConsoleKey(5, < 0, KeyHeight * 2.2, 0 > )
	PlaceConsoleKey(6, < 0, KeyHeight * 2.2, -ConsoleWidth / 4 > )
	PlaceConsoleKey(7, < 0, KeyHeight * 3.4, ConsoleWidth / 4 > )
	PlaceConsoleKey(8, < 0, KeyHeight * 3.4, 0 > )
	PlaceConsoleKey(9, < 0, KeyHeight * 3.4, -ConsoleWidth / 4 > )
	
	//DigitsScreen
	box{< -0.0001, ConsoleHeight * 9 / 12, -DigitsScreenWidth / 2 >,< -0.011, ConsoleHeight * 11 / 12, DigitsScreenWidth / 2 > 
		texture{ pigment{ color srgb 13 / 255 } finish{ specular 0.2 roughness 0.02 } } 
	}
	
	//OkButton
	box{ < -0.0001, 0.01, 0.01 >, < -0.011, KeyHeight, DigitsScreenWidth / 2 > texture{ pigment{ color srgb < 0, 1, 0 > } finish{ specular 0.01 roughness 0.01 } } }
	
	//CancelButton
	box{ < -0.0001, 0.01, -DigitsScreenWidth / 2 >, < -0.011, KeyHeight, -0.01 > texture{ pigment{ color srgb < 1, 0, 0 > } finish{ specular 0.01 roughness 0.01 } } }
}

//For the balcony
#declare SmallDoorA = object{ DoorA_LeftPart scale < 1, 1, 1 > }
#declare SmallDoorA_Size = max_extent( SmallDoorA ) - min_extent( SmallDoorA );