//The u 'letter' along the blue twelve
#declare U_Corridor_Limit = -11;
#declare BlueU_Symbol= 
prism{
	linear_sweep linear_spline 0.001, -1, 
	9, 
	< 4, U_Corridor_Limit >, < 4, 4 >, < 10, 4 >, < 10, U_Corridor_Limit >, < 9, U_Corridor_Limit >, < 9, 3 >, < 5, 3 >, < 5, U_Corridor_Limit > ,< 4, U_Corridor_Limit > 
}                

#declare ShopDoorHighness = 3.25;//Should be less than 5
#declare DoorDeepness = -0.2;       
#declare ptA0 = < 0, ShopDoorHighness, -4 >;
#declare ptB0 = < 0, ShopDoorHighness, -3 >;
#declare ptC0 = < 0, 0, -4 >;
#declare ptD0 = < 0, 0, -3 >;
#declare ptE0 = < 0, 1, -3 >;
#declare ptF0 = < 0, 0.5, -2.5 >;
#declare ptG0 = < 0, 0.5, 2.5 >;
#declare ptH0 = < 0, 0, 3 >;
#declare ptI0 = < 0, 1, 3 >;
#declare ptJ0 = < 0, ShopDoorHighness, 3 >;
#declare ptK0 = < 0, ShopDoorHighness, 4 >;
#declare ptL0 = < 0, 0, 4 >;

#declare ptB1 = < DoorDeepness, ShopDoorHighness, -3 >;
#declare ptE1 = < DoorDeepness, 1, -3 >;
#declare ptF1 = < DoorDeepness, 0.5, -2.5 >;
#declare ptG1 = < DoorDeepness, 0.5, 2.5 >;
#declare ptI1 = < DoorDeepness, 1, 3 >;
#declare ptJ1 = < DoorDeepness, ShopDoorHighness, 3 >;

#declare Door2 = 
union{
	mesh{//The door 'U'
		triangle{ptA0, ptB0, ptC0}
		triangle{ptB0, ptC0, ptD0}
		triangle{ptE0, ptF0, ptD0}
		triangle{ptD0, ptF0, ptG0}
		triangle{ptD0, ptG0, ptH0}
		triangle{ptG0, ptH0, ptI0}
		triangle{ptH0, ptJ0, ptK0}
		triangle{ptH0, ptK0, ptL0}
		texture{ Metal_tex1 }
	}
	mesh{//'x' door thickness
		triangle{ptB0, ptB1, ptE0}
		triangle{ptB1, ptE0, ptE1}
		triangle{ptE0, ptE1, ptF0}
		triangle{ptE1, ptF1, ptF0}
		triangle{ptF0, ptF1, ptG0}
		triangle{ptF1, ptG0, ptG1}
		triangle{ptG0, ptG1, ptI0}
		triangle{ptG1, ptI0, ptI1}
		triangle{ptI0, ptI1, ptJ0}
		triangle{ptJ0, ptJ1, ptI1}
		texture { Metal_tex2}					   
	}
	mesh{//door center background
		triangle{ptE1, ptF1, ptG1}
		triangle{ptE1, ptG1, ptI1}
		triangle{ptB1, ptE1, ptI1}
		triangle{ptB1, ptI1, ptJ1}
		texture{ Metal_tex2}
	}
	//Two blue rectangles
	box{ < 0, 0.5, -2 >, < DoorDeepness, ShopDoorHighness, -1 > texture{ OpaqueBlueTexture } }
	box{ < 0, 0.5, 1 >, < DoorDeepness, ShopDoorHighness, 2 > texture{ OpaqueBlueTexture } }
}

#declare Door2_Size = max_extent( Door2 ) - min_extent( Door2 );

//the twelve figure on the ground 
#declare Floor12Figure =
		union {
				//The 1 figure
				prism {linear_sweep linear_spline 0.001, -0.4 ,5 <10,6>, <10,12>, <9,12>, <9,6>, <10, 6> }
				//The 2 figure
				prism {linear_sweep linear_spline 0.001, -0.4,16 <7,6> <5,6> <4,7> <4,8> <7,11> <4,11> <4,12> <8,12> <8,11> <5,8> <5,7> <7,7> <7,7.5> <8,7.5> <8,7>	<7, 6>	}  
			  }          
//Lizard styled girder
#declare Girder1 = union {
							prism{ linear_sweep linear_spline 0, 0.5, 7 <0,0> <-1,0.75> <-2,0> <-2,0.25> <-1,1> <0,0.25> <0, 0> }
							box {< 0, -0.1, 0 > < -2, 0.6, 0.25 > }
							box {< 0, -0.1, 0.75 > < -2, 0.6, 1 > }
							rotate 90 * x
							texture{ GirderTexture }
						 }                   
    
#declare Girder2=//The 'M' shaped grider part
union {
       prism {linear_sweep linear_spline 0, 0.5, 7 <0,0.75> <-0.5,0> <-1,0.75> <-1,1> <-0.5,0.25> <0,1> <0, 0.75> }
       box {<0,-0.1,0> <-1,0.6,0.25>}
       box {<0,-0.1,0> <-0.25,0.6,1>}
       box {<-0.75,-0.1,0> <-1,0.6,1>}
       rotate 90*x
       texture{GirderTexture}
}          
       
//To make girder
#macro MakeGirder( GirderObject, Z_Coord, FinalCount, X_TranslateAdd)
	union{
		#for( It, 0, FinalCount - 1 )
			object{ GirderObject translate < 4 + 2 * It, 10, Z_Coord > }
		#end
		translate X_TranslateAdd * x
	}
#end   
  
#declare MainBlock = 
prism { linear_sweep linear_spline 
	0, 14, 
	7 
	<0,-10>, <0,8>, <-4,8>, <-6,6>,	<-10,6>, <-10,-10>,	<0, -10> 
	rotate -90 * z translate < 0, 0, -8 >
}

#declare CorridorDeletingBlock = 
prism { linear_sweep linear_spline -1, ShopDoorHighness, 5 < 2, 2 > < 12, 2 > < 12, -100 > < 2, -100 > < 2, 2 > }       

#declare TopBlock = 
difference {
	box {<5,5,-1> <13,10,-3>}
	cylinder {<5.5,  5, -1>, <5.5 , 10, -1>,0.1} 
	cylinder {<12.5, 5, -1>, <12.5, 10, -1>,0.1}
	box {<6.5, 5.5,-0.5> <7.5, 9.5,-2>}
	box {<8.5, 5.5,-0.5> <9.5, 9.5,-2>}
	box {<10.5,5.5,-0.5> <11.5,9.5,-2>}                  
}

#declare BlackShutter = 
box{ < 0, 0, 0 >, < 1, 0.035, 1 > rotate 45 * x pigment{ color srgb 0.9 } finish { metallic } }

#declare MissionFinalBlock = 
difference{
	union {
		object{ MainBlock }
		object{ TopBlock translate -2 * x }
	}
	object{ CorridorDeletingBlock }
	texture{ BeigeConcrete }            
}  

#declare Pillar = 
union{
	box{<-1,0,-1> <1,1,1>}
	prism { conic_sweep linear_spline 1, 0, 5, <1,1> <-1,1> <-1,-1> <1,-1> <1, 1> rotate 180 * x translate 2*y}
	box {<-1,3.5,-1> <1,4,1>}
	difference {
		box {<-0.5,1.5,-0.5> <0.5,3.5,0.5>}
		box {<1,1.7,-0.3> <0.3,3.3,0.3>}
		box {<-1,1.7,-0.3> <-0.3,3.3,0.3>}
		box {<-0.3,1.7,1> <0.3,3.3,0.3>}
		box {<-0.3,1.7,-1> <0.3,3.3,-0.3>}
	}
	texture{ BeigeConcrete }         
}                     

#declare PillarPipe = 
union{
	box {<-0.8, 4, -0.8> <0.8, 5, 0.8> pigment{ color srgb 0.1 } }
	cylinder {<0.5 ,5 ,-0.5> ,<0.5 ,8 ,-0.5> ,0.2 texture{ Metal_tex1 } }
	cylinder {<0.5 ,5 ,0.5>  ,<0.5 ,8 ,0.5 >  ,0.2 texture{ Metal_tex1 } }
	box {<-1,8,-1> <1,12,1> texture{ BeigeConcrete } }
}

#macro MakePillar(Position, PillarPipeYRotation)
	object{ Pillar translate Position }
	object{ PillarPipe rotate PillarPipeYRotation * y translate Position }
#end

#declare Spot_objet = cylinder {<0,0,0>,<0,0.1,0>,0.3 texture { pigment {srgb 2.25} } }
   
#macro CeilingSpot( SpotPosition )
	light_source {
		SpotPosition
		color srgb < 1, 1, 1 >
		looks_like{ Spot_objet }
	}
#end               

#macro MakeBalcony(BackgroundWallsTexture)
union{      
	union{ 
		box {<2,5,4> <-10,5.1,14> } 
		box {<2,9,4> <-10,11,14>}
		prism {linear_sweep linear_spline 5, 6, 9 <-10,4> <-10,4.5> <1.5,4.5> <1.5,13.5> <-10,13.5> <-10,14> <2,14> <2,4> <-10, 4> }
		box{<2,6,4> <1.5,9,4.5>} 
		box{<2,6,13.5><1.5,9,14>}
		texture{ BeigeConcrete }                 
	} 
	//Pane x= 1.6 -> 1.9 (face pane)| others:  z= 4.1 -> 4.4 et 13.6 -> 13.9
	box{<1.6,6,4.5> <1.9,9,13.5> texture{ Glass } interior{ ior 1.5 } }
	box{<1.5,6,4.1> <-2,9,4.4> texture{ Glass } interior{ ior 1.5 } }
	box{<1.5,6,13.6> <-2,9,13.9> texture{ Glass } interior{ ior 1.5 } }
	//Background walls
	#local BalconyDoorCenter = 9;
	difference{
		union{
			box{< -2, 5, 4 >, < -10, 9, 4.5 - newBrickMortarWidth - 0.001 > }
			box{< -2, 5, 13.5 + newBrickMortarWidth + 0.001 >, < -10, 9, 14 > }
			box{< -10, 5, 4 >, < -20, 9, 14 > }
		}
		box{ < -9, 5, BalconyDoorCenter - SmallDoorA_Size.x >, < -19, 5 + DoorA_Height, BalconyDoorCenter + SmallDoorA_Size.x > }
		texture{ BackgroundWallsTexture }
	}
	object{ SmallDoorA rotate 90 * y translate < -11 - 0.5, 5, BalconyDoorCenter + SmallDoorA_Size.x > }
	object{ SmallDoorA rotate -90 * y translate < -11 - 0.5 + DoorA_Depth, 5, BalconyDoorCenter - SmallDoorA_Size.x > }
	object{ DoorConsole rotate 180 * y translate < -10, 6, BalconyDoorCenter + SmallDoorA_Size.x + 0.5 > }
}   
#end
  