//Normale pour un grillage
#declare NormG_Base =	normal{gradient x 2 slope_map{ [0 <0, 1>][.1 <1, 0>][.9 <1, 0>][1 <0, -1>]}}
#declare NormG_Final = normal{ average normal_map{ [1 NormG_Base][1 NormG_Base rotate y*90]}}

#declare T_HD = texture{ pigment{ color srgb 0.85} finish{specular 0.1 roughness 0.1} }
#declare RackTexture = texture{ pigment{ color srgb 0.24} normal{NormG_Final rotate -90*x scale 0.075} finish{specular 0.05 roughness 0.05} }
#declare HandleTexture = texture{ pigment{ color srgb 1} finish{specular 0.25 roughness 0.45} }
#declare ShelfTexture = texture{ pigment{ color srgb 0.16} finish{specular 0.1 roughness 0.1} }

#declare BoxBaieServ = box{ < -0.8, 0, 0.2 >, < 0.8, 0.5, 1.8 > texture{ RackTexture } }

//Translate 0 et (0.5 * 2) * y
#declare Pack_HD = box{<-0.1, 0.5 / 8, 1.8>,<-0.6, 0.5 / 8 * 3, 1.8 + 0.01> texture{T_HD}}


#declare HandleRadius = 0.025;

#declare RackHandle = 
sphere_sweep{linear_spline 6,
	<0, 0.125				, 1.8>, HandleRadius,
	<0, 0.125				, 1.8 + 0.11>, HandleRadius,
	<0, 0.125 +(0.25* (1/3)), 1.8 + 0.2>, HandleRadius,
	<0, 0.125 +(0.25* (2/3)), 1.8 + 0.2>, HandleRadius,
	<0, 0.125 + 0.25        , 1.8 + 0.11>, HandleRadius,
	<0, 0.125 + 0.25        , 1.8> , HandleRadius
	texture{ HandleTexture} 
}

#declare LedRadius = 0.02;

#macro MakeLED( LedTranslate, LedColor )
	sphere{
		   0, 1 pigment{ color srgbft <1, 1, 1, 0, 1>} hollow on no_shadow
		   interior{
					media{ emission 40
							density{ spherical 
									density_map{
											  [0 srgb <0, 0, 0>]
											  [0.1 srgb LedColor]
											  [0.8 srgb LedColor]
											  [1 srgb LedColor]
											 }
							}
					}
			}
			scale LedRadius
			translate LedTranslate
		}
#end					
									
#macro MakeServerDrawer( TranslateVector, LedAColor, LedBColor )
	union{
		object{BoxBaieServ}
		object{Pack_HD translate 0}
		object{Pack_HD translate (0.5 / 2 )* y}
		object{ RackHandle translate -0.7 * x} 
		object{ RackHandle translate 0.7 * x} 
		MakeLED(<0, 0.5 * (1/3), 1.815>, LedAColor)
		MakeLED(<0, 0.5 * (2/3), 1.815>, LedBColor)
		translate TranslateVector
	}
#end									

#declare ShelfSide = 
difference{
	box{ < -0.025, 0, -0.1 >, < 0.025, 0.25, 0.1 > }
	box{ < -1, 0.04, -0.05 >, < 1, 0.21, 0.05 > }
	texture{ HandleTexture }
}
									
#macro MakeServerShelf( TranslateVector, SideNumber)
	union{
		#for( It, 0, SideNumber - 1 )
			object{ ShelfSide translate 0.25 * It * y}
		#end
			texture{ ShelfTexture }
			translate TranslateVector
		}
#end									