#include "math.inc"

#declare RedColor = color srgb < 1, 0, 0 >;
#declare StalkColor = color srgb 0.85;
#declare PullColor = color srgb 0.15;
#declare BoxFinish = finish{ specular 0.15 roughness 0.2 metallic}

#declare MetalTexture = texture{ pigment{ StalkColor } finish{ BoxFinish } }
#declare PullTexture = texture{ pigment{ PullColor } finish{ BoxFinish } }

#declare BoxWidth = 2;
#declare BoxDepth = 6;
#declare BoxHeight = 3.5;
#declare BaseHeight = BoxHeight * 2 / 5;
#declare CompHeight = BoxHeight / 5;
#declare CompSpace = 0.02;

#declare ToolBase = box{ < -BoxWidth / 2, 0, -BoxDepth / 2 >,< BoxWidth / 2, BaseHeight, BoxDepth / 2 > }

#declare Comp = box{ < -BoxWidth / 4 + CompSpace, 0.075, -BoxDepth / 2 > , < BoxWidth / 4 - CompSpace, CompHeight, BoxDepth / 2> }

#declare LowerPoint = < -BoxWidth / 2 * 0.8,		 // -0.8
						BaseHeight * 0.8,			// 1.12
						0 >;

#declare UpperPoint = < -BoxWidth / 2 * 0.25, 					// -0.2
						0.8 * CompHeight + BoxHeight * 2 / 5, 	// 1.96
						0 >;

#declare StalkLength = VDist( LowerPoint, UpperPoint );
#declare HorizontalVector = < 1, 0, 0>;
#declare StalkVector = UpperPoint - LowerPoint;
#declare StalkAngle = VAngleD(StalkVector, HorizontalVector );
#declare StalkWidth = 0.15;
#declare StalkDepth = 0.025;

#declare PullRadius = 0.08;
#declare PullHighness = 0.7;

#declare StalkObject = 
union{
	sphere{ < 0, 0, -StalkDepth / 2 >, StalkWidth / 4 }
	cylinder{	< 0, 0, -StalkDepth >,
				< 0, 0, 0 >, 
				StalkWidth / 2 }
	box{		< -StalkWidth / 2,	0,				-StalkDepth >,
				< StalkWidth / 2, 	StalkLength,	 0> }
	cylinder{	< 0, StalkLength, -StalkDepth >,
				< 0, StalkLength, 0 >, 
				StalkWidth / 2 }
	sphere{ < 0, StalkLength, -StalkDepth / 2 >, StalkWidth / 4 }
	texture{ MetalTexture }
}

#declare Pull =
union{
	box{ <-BoxWidth / 8, 0, -1.5>,< BoxWidth / 8, PullRadius * 2,-0.5 - PullRadius * 2 > texture{ MetalTexture } }
	box{ <-BoxWidth / 8, 0, 1.5>,< BoxWidth / 8, PullRadius * 2,0.5 + PullRadius * 2 > texture{ MetalTexture } }
	union{
		cylinder{ < 0, PullRadius, -0.5 - PullRadius >, < 0, PullRadius, -0.5 - PullRadius * 2 >, PullRadius }
		cylinder{ < 0, PullRadius, 0.5 + PullRadius >, < 0, PullRadius, 0.5 + PullRadius * 2 >, PullRadius }
		sphere{ < 0, PullRadius, -0.5 - PullRadius >, PullRadius }
		sphere{ < 0, PullRadius, 0.5 + PullRadius >, PullRadius }
		cylinder{ < 0, PullRadius, -0.5 - PullRadius >, < 0, PullHighness, -0.5 - PullRadius >, PullRadius }
		cylinder{ < 0, PullRadius, 0.5 + PullRadius >, < 0, PullHighness, 0.5 + PullRadius>, PullRadius }
		sphere{ < 0, PullHighness, -0.5 - PullRadius >, PullRadius }
		sphere{ < 0, PullHighness, 0.5 + PullRadius >, PullRadius }
		cylinder{ < 0, PullHighness, -0.5 - PullRadius >, < 0, PullHighness, 0.5 + PullRadius >, PullRadius }
		translate -PullRadius * y rotate -90*z translate PullRadius * y
		texture{ PullTexture }
	}
}

#declare SideStalks = union{
	object{ StalkObject rotate -(90 - StalkAngle) * z translate < LowerPoint.x, LowerPoint.y, -BoxDepth / 2 > }
	object{ StalkObject rotate (90 - StalkAngle) * z translate < -LowerPoint.x, LowerPoint.y, -BoxDepth / 2 >  }
	object{ StalkObject rotate -(90 - StalkAngle) * z translate < LowerPoint.x, LowerPoint.y + CompHeight, -BoxDepth / 2 > }
	object{ StalkObject rotate (90 - StalkAngle) * z translate < -LowerPoint.x, LowerPoint.y + CompHeight, -BoxDepth / 2 >  }
	object{ StalkObject rotate -(90 - StalkAngle) * z translate < LowerPoint.x, LowerPoint.y + CompHeight * 2, -BoxDepth / 2 > }
	object{ StalkObject rotate (90 - StalkAngle) * z translate < -LowerPoint.x, LowerPoint.y + CompHeight * 2, -BoxDepth / 2 >  }
}

#declare ToolsBox =
union{
	union{
		object{ ToolBase }
		object{ Comp translate < -BoxWidth / 4,BoxHeight * 2 / 5, 0 > }
		object{ Comp translate < BoxWidth / 4,BoxHeight * 2 / 5, 0 > }
		object{ Comp translate < -BoxWidth / 4,BoxHeight * 3 / 5, 0 > }
		object{ Comp translate < BoxWidth / 4,BoxHeight * 3 / 5, 0 > }
		object{ Comp translate < -BoxWidth / 4,BoxHeight * 4 / 5, 0 > }
		object{ Comp translate < BoxWidth / 4,BoxHeight * 4 / 5, 0 > }
		texture{ pigment{ RedColor } finish{ BoxFinish } }
	}
	object{ SideStalks }
	object{ SideStalks translate (BoxDepth + StalkDepth ) * z }
	object{ Pull translate BoxHeight * y }
}
