#version 3.7;

#declare Radiosity = true;

// x axis : from center to the left
// z axis : from center to the right
//CameraNum must be defined as command line parameter
#declare HangarRoomViewCam = 0;
#declare CorridorViewCam = 1;
#declare ShopDoorViewCam = 2;

#declare MainRoomMinCorner = < 0, 0, 0 >;
#declare MainRoomMaxCorner = < 22, 10, 23.5 >;

global_settings{
	assumed_gamma 1.0
	max_trace_level 16
	#if( Radiosity )
		#default{ finish{ ambient 0 } }
		
		//Theses radiosity settings are quality ones (improving their values shouldn't improve output image quality that much.)
		radiosity{
			pretrace_start 64 / image_width
			pretrace_end 2 / image_width
			error_bound 0.2
			minimum_reuse 0.01
			nearest_count 9
			count 800
			recursion_limit 2
			always_sample off
			low_error_factor 0.7
			gray_threshold 0
			brightness 1
			adc_bailout 0.01 / 2
			normal on
			media on
		}
	#end
}

#include "includes/colorsMercenaires.inc"
#include "includes/texturesMercenaires.inc"
#include "includes/textures.inc"
#include "includes/sceneObjects.inc"
#include "includes/roomDoors.inc"
#include "includes/serverRack.inc"
#include "includes/neonObject.inc"
#include "includes/toolsBox.inc"
#include "includes/woodCrate.inc"
#include "includes/spaceCrate1.inc"
#include "includes/affineFunctionSetter.inc"

#if( CameraNum = HangarRoomViewCam )
	camera{
		location < 20, 6, 19 >
		look_at < 0, 1, 2 >
		right x * image_width / image_height
		up y
	}
#elseif( CameraNum = CorridorViewCam )
	camera{
		location < 7, 1.5, 10 >
		look_at < 7, 1.25, -10 >
		right x * image_width / image_height
		up y
	}
#elseif( CameraNum = ShopDoorViewCam )
	camera{
		location < 3.5, 3, 3 >
		look_at < 13, 3.05, 16 >
		right x * image_width / image_height
		up y
	}
#end

object{ CeilingSpot( < 9, 9.8, 10.5 > ) }

//Mainroom ceiling
box{ MainRoomMinCorner + <-1, 10, -1 >, MainRoomMaxCorner + < 1, 1, 1 > pigment{ color srgb 0.752941 } normal{ FinalNorm } }

//The corridor neons | x = 2 and x = 12 (side of corridor) | z = 3 / 6 / 9 along the corridor
// 3(neonTube position) 4(y neonTube rotation) 5(lightPointAt)
AddNeonTube( < 2.02,  0.5, -8 >,   0, < 7, 1.5, -8 > )
AddNeonTube( < 2.02,  0.5, -11 >,   0, < 7, 1.5, -11 > )
AddNeonTube( < 11.98, 0.5, -8 >, 180, < 7, 1.5, -8 > )
AddNeonTube( < 11.98, 0.5, -11 >, 180, < 7, 1.5, -11 > )

//The floor in the main room
plane{ y, 0 pigment{ FloorPig } }

//The big blue 'u'
object{ BlueU_Symbol texture{ OpaqueBlueTexture } }

//The blue 'twelve' on the floor
object{ Floor12Figure texture{ OpaqueBlueTexture } }

//The door under the compter room (Balcony) and the code console
object{ Door2 translate < 0, 0, 9 > }
object{ DoorConsole rotate -135 * y translate < 0.5, 1, 13.5 > }

//The space crate near the door in the main room
object{ SpCr1_CompleteCrateWithCover scale 0.5 rotate 17 * y translate < 4.5, 0, 16 > }
object{ SpCr1_CompleteCrateWithCover scale 0.5 rotate 0 * y 
		translate < MainRoomMaxCorner.x - 1.25, 0, DoorA_HangarZ_Pos + DoorA_Width / 2 + 0.75 > 
}

//The door inside the tunnel
#declare Tunnel_X_Size = 10;
object{ Door2 scale < 1, 1, Tunnel_X_Size / Door2_Size.z > rotate -90 * y translate < 7, 0, -16 > }

union{
	//Beige wall at left:
	prism{ linear_sweep linear_spline 0,5,8, <0,-4> <-1,-4> <-1,5> <0,5> <1,4> <1,2>  <0,2> <0, -4> } 
	//Beige wall at right:
	prism{ linear_sweep linear_spline 0,5,8  <0,13> <1,14> <1,15>  <0,15> <0,30> <-1,30><-1,13> <0, 13> } 
	//The wall above the door:                                                                                
	prism{ linear_sweep linear_spline  3,5,5 <0,4>  <0,14> <1,14> <1,4> <0, 4> }
    texture{ BeigeConcrete } 
}

//The girders
MakeGirder( Girder1, 0, 12, -3 )
MakeGirder( Girder1, 9, 12, 0) 
MakeGirder( Girder1, 13, 12, 0 )
MakeGirder( Girder1, 19.5, 12, 0 )

object{ MissionFinalBlock }

      #declare newBrickHeight = 0.5;
      #declare newBrickWidth  = 1;
      #declare newBrickDepth  = 1;
      #declare newBrickBozoScale = 1;
      #declare newBrickMortarWidth = 0.05;
      #declare newBrickTurbulence = 0;
      #declare newBrickLowlight = color srgb < 0.4, 0.35, 0.3 >;
      #declare newBrickHighlight = color srgb < 0.7, 0.65, 0.5 >;
      #declare newBrickMidtone = color srgb < 0.6, 0.5, 0.3 >;

#include "includes/bricks.inc" //brick macro found on internet (I am not the author of this macro)
//Concrete wall above the door -4->4 | 14-> 30 
#declare BrickScale = 0.5;

box{ < -1, 0, -4 >, < -2, 11, 4 > texture { T_newBrick scale BrickScale } }
box{ < -1, 0, 14 >, < -2, 11, 30 > texture { T_newBrick scale BrickScale } }

//Concrete wall to the very left
box{ < 14, 0, -2 >, < 20, 11, -10 > texture{ T_newBrick scale BrickScale } }

//The wall behind the camera/view on the left
difference{
	box{ < MainRoomMaxCorner.x, MainRoomMinCorner.y, MainRoomMinCorner.z - 20 >, 
		< MainRoomMaxCorner.x + 30, MainRoomMaxCorner.y, MainRoomMaxCorner.z + 20 > 
		texture{ T_newBrick scale BrickScale } 
	}
	
	//For the 'exit' door some wall space is removed, see 'includes/roomDoors.inc" for the constants/values below
	box{ < MainRoomMaxCorner.x -1, 0, DoorA_HangarZ_Pos - DoorA_Width / 2 >, 
		< MainRoomMaxCorner.x + 9, DoorA_Height, DoorA_HangarZ_Pos + DoorA_Width / 2 > texture{ T_newBrick scale BrickScale } 
	}
}

//The wall behind the camera/view on the right
difference{
	box{ < MainRoomMinCorner.x, MainRoomMinCorner.y, MainRoomMaxCorner.z >, 
		< MainRoomMaxCorner.x, MainRoomMaxCorner.y, MainRoomMaxCorner.z + 10 > 
		texture{ T_newBrick scale BrickScale } 
	}
	
	//For the 'staff' door some wall space is removed, see 'includes/roomDoors.inc' for the constants values below
	box{ < DoorB_HangarX_Pos - DoorA_Width / 2, MainRoomMinCorner.y, MainRoomMaxCorner.z - 1 >, 
		< DoorB_HangarX_Pos + DoorA_Width / 2, DoorA_Height, MainRoomMaxCorner.z + 9 > 
		texture{ T_newBrick scale BrickScale } 
	}
}

MakePillar( MainRoomMinCorner + < 2, 0, 2 >, 0 )//Pillar between corridor and shop door
MakePillar( MainRoomMinCorner + < 16, 0, 0 >, 90 )//Pillar near the red tool box set on the wooden crate
MakePillar( < MainRoomMinCorner.x + 2, 0, 16 >, 0 ) //Pillar between staff door and shop door (near the two stacked wooden crates)
MakePillar( < MainRoomMaxCorner.x, 0, MainRoomMaxCorner.z > - < 2, 0, 2 >, 0 ) //Pillar between staff and exit doors

#for( Column, 0, 2 )
	#local X_Position = SetWithAffineFunction( 0, 2, 4.5, 8.5, Column );
	#for( Number, 0, 4 )
		#local Y_Position = SetWithAffineFunction( 0, 4, 6.5, 9.7, Number );
		object{ BlackShutter translate < X_Position, Y_Position, -2 > }
	#end
#end

MakeBalcony(texture { T_newBrick scale BrickScale } )

#declare ToolsBoxScale = 0.5;
#declare CratesScale = 0.375;

//Crates on the right
object{ CrateObj scale CratesScale translate < DoorB_HangarX_Pos - DoorA_Width / 2 - 3, 0, MainRoomMaxCorner.z - 2 > }
object{ CrateObj scale CratesScale translate < DoorB_HangarX_Pos - DoorA_Width / 2 - 3, 1.5 * CratesScale, MainRoomMaxCorner.z - 2 > }

//Crate on the left
object{ CrateObj scale CratesScale translate < 16.2, 0, 3.5 > }

//Toolbox on the left crate
object{ ToolsBox scale 0.25 * ToolsBoxScale rotate 35 * y translate < 16.25, 1.5 * ToolsBoxScale, 3.5> }
	
#declare BrightGreen = <0, 1, 0>; 
#declare BrightRed = <1, 0, 0>;

union{
	MakeServerDrawer(< 0, 1, 0.3 >, BrightRed,  BrightGreen)
	MakeServerDrawer(< 0, 1.75, 0.3 >, BrightGreen, BrightGreen)
	MakeServerDrawer(< 0, 2.5, 0.3 >, BrightGreen, BrightGreen)
	MakeServerDrawer(< 0, 3.25, 0.3 >, BrightGreen, BrightRed)

	MakeServerShelf(< -0.8 - 0.025  , 0, 0.7 >, 16) //back right
	MakeServerShelf(< 0.8 + 0.025   , 0, 0.7 >, 16) //back left
	MakeServerShelf(< -0.8 - 0.025  , 0, 1.8 >, 16) //front right
	MakeServerShelf(< 0.8 + 0.025   , 0, 1.8 >, 16) //front left
	translate < -3.5, 5,4.25 >
}

//Exit door things
object{ DoorA_LeftPart rotate 90 * y translate < MainRoomMaxCorner.x + 0.5, 0, DoorA_HangarZ_Pos + DoorA_Width / 2 > }
object{ DoorA_LeftPart rotate -90 * y translate < MainRoomMaxCorner.x + 0.5 + DoorA_Depth, 0, DoorA_HangarZ_Pos - DoorA_Width / 2 > }
object{ DoorConsole translate < MainRoomMaxCorner.x, DoorA_Height / 3, DoorA_HangarZ_Pos - DoorA_Width / 2 - ConsoleWidth * 2 > }
object{ ExitText translate -ExitTextCenter translate < MainRoomMaxCorner.x - TextDepth / 2, DoorA_Height + 1, DoorA_HangarZ_Pos > }

//Staff door things
object{ DoorA_LeftPart translate < DoorB_HangarX_Pos - DoorA_Width / 2, 0, MainRoomMaxCorner.z + 0.5 > }
object{ DoorA_LeftPart rotate 180 * y translate < DoorB_HangarX_Pos + DoorA_Width / 2, 0, MainRoomMaxCorner.z + 0.5 + DoorA_Depth > }
object{ DoorConsole rotate -90 * y translate < DoorB_HangarX_Pos + DoorA_Width / 2 + ConsoleWidth * 2, DoorA_Height / 3, MainRoomMaxCorner.z > }
object{ StaffText translate -StaffTextCenter translate < DoorB_HangarX_Pos, DoorA_Height + 1, MainRoomMaxCorner.z - TextDepth / 2 > }