#declare Brown1_srgb = color srgb < 122 / 255, 72 / 255, 57 / 255 >;
#declare Brown2_srgb = color srgb < 126 / 255, 76 / 255, 62 / 255 >;
#declare Brown3_srgb = color srgb < 114 / 255, 62 / 255, 53 / 255 >;
#declare Brown4_srgb = color srgb < 102 / 255, 53 / 255, 43 / 255 >;
#declare Brown5_srgb = color srgb < 93 / 255, 43 / 255, 38 / 255 >;
	
#macro Pig_5colors_Wrinkles( multiplicateur, Col1, Col2, Col3, Col4, Col5)
		pigment{wrinkles color_map{ 
                                   [0.0 Col3*multiplicateur]  
                                   [0.125 Col2*multiplicateur]
                                   [0.25 Col1*multiplicateur] 
                                   [0.375 Col2*multiplicateur]
                                   [0.5 Col3*multiplicateur]
                                   [0.675 Col4*multiplicateur]
                                   [0.75 Col5*multiplicateur] 
                                   [0.875 Col4*multiplicateur]
                                   [1.0 Col3*multiplicateur]
                                  }
                    scale 0.005
        }
#end

#declare Pig_brown2 = Pig_5colors_Wrinkles(1.12 ,Brown1_srgb, Brown2_srgb, Brown3_srgb, Brown4_srgb, Brown5_srgb)

#declare GroundScale = 160;

#declare HF_Ground_Scale = 4;

#declare WrinklesPig = 
pigment{ wrinkles
	color_map{
		[ 0 color srgb 0.1 ]
		[ 0.25 color srgb 0.35 ]
		[ 0.5 color srgb 0.25 ]
		[ 0.75 color srgb 0.35 ]
		[ 1 color srgb 0.1 ]
	}
	scale <0.025, 0.025, 1> 
}

#declare HF_Ground = 
height_field{
	function 1024, 1024 {
		pigment{ WrinklesPig } 
	}
	smooth
	translate < -0.5, 0, -0.5 >
	scale < GroundScale, 1, GroundScale >
	
	pigment{ Pig_brown2 }
}

#declare TreesZStartingPos = 20;

#macro PlaceTrees(HeightField, TreeObject)
	#local RotateSeed = seed( 123 );
	#local PlaceSeed = seed( 79230 );
	#local ScaleSeed = seed( 456 );
	#local Normal = < 0, 0, 0 >;
	#for( ItX, -GroundScale / 2 + 2, GroundScale / 2 - 2, 4 )
		#for( ItZ, TreesZStartingPos, GroundScale / 2 - 2, 4 )
			#local TreePos = trace( HeightField, < ItX, 1000, ItZ >, -y, Normal );
			#if( Normal.x != 0 | Normal.y != 0 | Normal.z != 0 )
				object{ TreeObject 
						scale 5 + 2 * rand(ScaleSeed)
						rotate rand(RotateSeed) * 360 * y 
						translate TreePos + < rand(PlaceSeed) * 3 - 1.5, 0, rand(PlaceSeed) * 3 - 1.5 > }
			#end
		#end
	#end
#end