//Grass texture
//#declare PigGrass = pigment{srgb<0.45, 0.6, 0.25>} //{srgb <0.4, 1, 0.1>}
#declare TGrass = texture{pigment{ color srgb < 94 / 255, 135 / 255, 63 / 255 > } }

#declare RandGen = seed(79230);
#declare RandEp = seed(79000);//Seed for space grass blades
#declare RandColor = seed(1234);
#declare RandRotate = seed(5678);

#declare GBDk = < 63 / 255, 82 / 255, 12 / 255 >; //Grass blade Dark color
#declare GBLg = < 109 / 255, 130 / 255, 67 / 255 >; //Grass blade light color
#declare GCoefDir = < GBLg.x - GBDk.x, GBLg.y - GBDk.y , GBLg.z - GBDk.z>; //Grass col coef dir

#declare GrassBladeFinish = finish{ diffuse 0.8 specular 0.35 roughness 0.01 }

#declare BladeDensity = 24;

#macro HasCollideWithAnObject(Object, PositionTest)
	#local Norm = < 0, 0, 0 >;
	#local Position = trace( Object, PositionTest, -y, Norm );
	#local HasCollided = 0;
	#if( Norm.x != 0 | Norm.y != 0 | Norm.z != 0 )
		#local HasCollided = 1;
	#else
		#local HasCollided = 0;
	#end
	HasCollided
#end

#macro PlaceGrass( GroundHeightField, FlatStones )
	#debug "Starting to place grass on the ground\n"
	#local GrassBladeCount = 0;
    #local Norm = <0, 0, 0>;
	
    #for(XCount, min_extent(GroundHeightField).x, max_extent(GroundHeightField).x )
		#for(ZCount, -5, TreesZStartingPos + 20 )
			#for(InXBetween, -BladeDensity, BladeDensity - 1)
				#for(InZBetween, -BladeDensity, BladeDensity - 1)
					#local Start = < XCount + (InXBetween + rand(RandGen)) / (BladeDensity * 2), 1000, ZCount + (InZBetween + rand(RandGen)) / (BladeDensity * 2) >;
					#declare PosBlade = trace( GroundHeightField, Start, -y, Norm );
					#if( Norm.x != 0 | Norm.y != 0 | Norm.z != 0 )
						#if( 0 = HasCollideWithAnObject( FlatStones, PosBlade ) )
							#if( rand(RandEp) > 0.5 )
								cylinder{0, <0, (0.025 + rand(RandGen)/25), 0>, 0.0085 scale <1,1,0.35> rotate <rand(RandRotate)*20-10 ,(360 * rand(RandGen) ), rand(RandRotate)*20-10> translate PosBlade 
									texture{pigment{color srgb<GCoefDir.x*rand(RandColor)+GBLg.x, GCoefDir.y*rand(RandColor)+GBLg.y, GCoefDir.z*rand(RandColor)+GBLg.z>} finish{ GrassBladeFinish }} }
								#local GrassBladeCount = GrassBladeCount + 1;
							#end
						#end
					#end
				#end
			#end
		#end
	#end
	#debug concat("Placed ", str(GrassBladeCount,0,0), " grass blades\n")
#end
